#ifndef __3DSCLASS_H__
#define __3DSCLASS_H__
// File: 3DSCLASS.h

#include <afx.h>
#include <afxcoll.h>
#include "obj3d.h"

typedef unsigned short ID;

#define CASE(param) case(0x##param): if (Treat_##param()==false) return false;break;
#define DECLARE_CASE(param) bool Treat_##param()
#define IMPLEMENT_CASE(param) bool C3dsFile::Treat_##param()

class C3dsFile:public CObject{
private:
	// fakefile management
	char *m_pHead;
	char *m_pCur;
	DWORD m_Len;
	CObList m_List;
protected:
	bool Process(DWORD*);
	bool myread(void *buffer, DWORD size);
	DWORD mytell();
	bool myseek(int offset, int origin);
	bool GetChunkId(unsigned short*, DWORD*);
	bool WalkInto(DWORD*);
	bool WalkNext(DWORD*);
	DECLARE_CASE(4d4d);
	DECLARE_CASE(3d3d);
	DECLARE_CASE(4000);
	DECLARE_CASE(4100);
	DECLARE_CASE(4110);
	DECLARE_CASE(4120);
	DECLARE_CASE(4140);
	DECLARE_CASE(B000);
	DECLARE_CASE(B008);
	DECLARE_CASE(B020);
public:
	bool Export(char *szName);
	void Center();
	void Translate(VECTOR *pTrans);
	bool GetMinMax(VECTOR * pMin, VECTOR * pMax);
	void RemoveEmptyObjects();
	void bide();
	C3dsFile(){}
	~C3dsFile();
	bool LoadFile(char*);
	bool Process();
	CObList* GetList();
};

#endif